package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

import javax.sound.sampled.Clip;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EditorPalette extends JPanel {
	
	private ArrayList<StaticBlockPaletteObject> staticBlockPaletteObjects;
	private ArrayList<PaletteObject> doorPaletteObjects;
	private ArrayList<PaletteObject> enemyPaletteObjects;
	private ArrayList<PaletteObject> widgetPaletteObjects;
	private ArrayList<PaletteObject> commentaryPaletteObjects;
	
	private int paddingBetweenObjects;
	private int paddingFromObjectToBorder;
	private int borderThickness;
	
	private int staticBlockTotalWidth;
	private int staticBlockTotalHeight;
	
	private int doorTotalWidth;
	private int doorTotalHeight;
	
	private int commentaryTotalWidth;
	private int commentaryTotalHeight;
	
	private int enemyTotalWidth;
	private int enemyTotalHeight;
	
	private int widgetTotalWidth;
	private int widgetTotalHeight;
	
	private PaletteObject selectedObject;
	
	private RoomEditorPanel parent;
	private JScrollPane scrollPane;
	
	private GoalScreenPaletteObject goalPalette;
	
	private LevelStartPaletteObject levelStartPalette;
	
	public void setScrollPane(JScrollPane theScrollPane) {
		scrollPane = theScrollPane;
	}
	
	public EditorPalette(int thePaddingBetweenObjects, int thePaddingToBorder, int theBorderWidth, RoomEditorPanel theParent) {
		
		staticBlockPaletteObjects = new ArrayList<StaticBlockPaletteObject>();
		doorPaletteObjects = new ArrayList<PaletteObject>();
		commentaryPaletteObjects = new ArrayList<PaletteObject>();
		enemyPaletteObjects = new ArrayList<PaletteObject>();
		widgetPaletteObjects = new ArrayList<PaletteObject>();
		
		parent = theParent;
		
		
		paddingBetweenObjects = thePaddingBetweenObjects;
		paddingFromObjectToBorder = thePaddingToBorder;
		borderThickness = theBorderWidth;
		
		this.setMaximumSize(new Dimension(500, 100));
		this.setMinimumSize(new Dimension(500, 100));
		this.setPreferredSize(new Dimension(500, 100));
		
		staticBlockTotalWidth = paddingBetweenObjects;
		staticBlockTotalHeight = 0;
		
		this.addNewToBlockPalette();
		this.addEditToBlockPalette();
		this.addEraserToBlockPalette();
		
		
		
		
		doorTotalWidth = paddingBetweenObjects;
		doorTotalHeight = 0;
		
		this.addMoveToDoorPalette();
		this.addNewWidgetToDoorPalette();
		this.addNewDoorToDoorPalette();
		this.addEditToDoorPalette();
		this.addForwardBackwardToDoorPalette();
		this.addCloneToDoorPalette();
		this.addEraserToDoorPalette();
		this.addHeartToDoorPalette();
		this.addFlagToDoorPalette();
		
		
		commentaryTotalWidth = paddingBetweenObjects;
		commentaryTotalHeight = 0;
		
		this.addMoveToCommentPalette();
		this.addNewRadioToCommentPalette();
		this.addNewSignToCommentPalette();
		this.addNewDoorToCommentPalette();
		this.addEditToCommentPalette();
		this.addForwardBackwardToCommentPalette();
		this.addCloneToCommentPalette();
		this.addEraserToCommentPalette();
		
		
		enemyTotalWidth = paddingBetweenObjects;
		enemyTotalHeight = 0;
		
		this.addMoveToEnemyPalette();
		this.addNewToEnemyPalette();
		this.addNewConveyorToEnemyPalette();
		this.addEditToEnemyPalette();
		this.addForwardBackwardToEnemyPalette();
//		System.out.println("[][][][]  after fwd/back:  enemyTotalWidth: " + enemyTotalWidth);
		this.addCloneToEnemyPalette();
//		System.out.println("[][][][]  after clone:  enemyTotalWidth: " + enemyTotalWidth);
		this.addEraserToEnemyPalette();
//		System.out.println("[][][][]  after eraser:  enemyTotalWidth: " + enemyTotalWidth);
		
		this.addRedEnemyToEnemyPalette();
//		System.out.println("[][][][]  after red:  enemyTotalWidth: " + enemyTotalWidth);
		this.addBlueEnemyToEnemyPalette();
//		System.out.println("[][][][]  after blue:  enemyTotalWidth: " + enemyTotalWidth);
		this.addGreenEnemyToEnemyPalette();
		this.addGrayEnemyToEnemyPalette();
		this.addYellowEnemyToEnemyPalette();
		this.addVioletEnemyToEnemyPalette();
		this.addRainbowBossToEnemyPalette();
		
		
		
		widgetTotalWidth = paddingBetweenObjects;
		widgetTotalHeight = 0;
		
		this.addMoveToWidgetPalette();
		this.addNewToWidgetPalette();
		this.addNewHurtzoneToWidgetPalette();
		this.addEditToWidgetPalette();
		this.addForwardBackwardToWidgetPalette();
		this.addCloneToWidgetPalette();
		this.addEraserToWidgetPalette();
		this.addStartPointToWidgetPalette();
		this.addGoalToWidgetPalette();
		
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				onClick(e);
			}
		});
		
		
	}
	
	
	private int getHeightOfLargestItem() {
		int returnValue = Integer.MIN_VALUE;
		
		if(parent == null || parent.getLayerControlPanel() == null)
			return returnValue;
		
		switch(parent.getLayerControlPanel().getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			if(staticBlockPaletteObjects != null) {
				for(StaticBlockPaletteObject p : staticBlockPaletteObjects) {
					if(p.getClickRect().height() > returnValue)
						returnValue = p.getClickRect().height();
				}
			}
			break;
		case LayerControlPanel.DOOR_LAYER:
			if(doorPaletteObjects != null) {
				for(int i = 0; i < doorPaletteObjects.size(); i++) {
					if(doorPaletteObjects.get(i) instanceof DoorDestinationPaletteObject) {
//						System.out.println("now in getHeightOfLargestItem; maybe we'll return: " + returnValue + ", or " + ((DoorDestinationPaletteObject) doorPaletteObjects.get(i)).getHeightOfCaptionIncludeSpacing());
						if(((DoorDestinationPaletteObject) doorPaletteObjects.get(i)).getHeightOfCaptionIncludeSpacing() > returnValue)
							returnValue = ((DoorDestinationPaletteObject) doorPaletteObjects.get(i)).getHeightOfCaptionIncludeSpacing();
					} else if(doorPaletteObjects.get(i).getClickRect().height() > returnValue)
						returnValue = doorPaletteObjects.get(i).getClickRect().height();
				}
			}
			break;
		case LayerControlPanel.ENEMY_LAYER:
			if(enemyPaletteObjects != null) {
				for(int i = 0; i < enemyPaletteObjects.size(); i++) {
					if(enemyPaletteObjects.get(i).getClickRect().height() > returnValue)
						returnValue = enemyPaletteObjects.get(i).getClickRect().height();
				}
			}
			break;
		case LayerControlPanel.WIDGET_LAYER:
			if(widgetPaletteObjects != null) {
				for(int i = 0; i < widgetPaletteObjects.size(); i++) {
					if(widgetPaletteObjects.get(i).getClickRect().height() > returnValue)
						returnValue = widgetPaletteObjects.get(i).getClickRect().height();
				}
			}
		}
		
		return returnValue;
	}
	
	public void addStaticBlockPaletteItem(char newChar) {
		
		if(newChar == '\0')
			return;
		
		
		int newbieClickRectMinX = staticBlockTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, newChar, paddingFromObjectToBorder, borderThickness, parent);
		
		
		staticBlockPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		staticBlockTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(staticBlockTotalWidth > this.getPreferredSize().width || staticBlockTotalHeight < maxHeight) {
			
			staticBlockTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			int newWidth = Math.max(500, staticBlockTotalWidth);
			int newHeight = Math.max(100, staticBlockTotalHeight);
			
			this.setPreferredSize(new Dimension(newWidth, newHeight));
			this.setMinimumSize(new Dimension(newWidth, newHeight));
			this.setMaximumSize(new Dimension(newWidth, newHeight));
			
		}
		
		if(scrollPane != null) {
//			scrollPane.repaint();
			scrollPane.revalidate();
		}
		
		readjustWidthAndHeight();
		
	}
	
	
	public void readjustWidthAndHeight() {
		
		int currentLayer;
		
		if(parent == null || parent.getLayerControlPanel() == null) {
			currentLayer = LayerControlPanel.BLOCK_LAYER;
//			System.out.println("using the block layer because the parent or the layer control panel is null!");
		} else {
			currentLayer = parent.getLayerControlPanel().getCurrentLayer();
//			System.out.println("using the whatever layer the layer control panel says..." + currentLayer);
		}
		
		int relevantWidth, relevantHeight;
		
//		System.out.println("just before the switch-block...");
		
		switch(currentLayer) {
		case LayerControlPanel.BLOCK_LAYER:
			relevantWidth = staticBlockTotalWidth;
			relevantHeight = staticBlockTotalHeight;
			break;
		case LayerControlPanel.DOOR_LAYER:
			//going to have to add this soon
			relevantWidth = doorTotalWidth;
			relevantHeight = doorTotalHeight;
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
			relevantWidth = commentaryTotalWidth;
			relevantHeight = commentaryTotalHeight;
			break;
		case LayerControlPanel.ENEMY_LAYER:
			relevantWidth = enemyTotalWidth;
			relevantHeight = enemyTotalHeight;
			break;
		case LayerControlPanel.WIDGET_LAYER:
			relevantWidth = widgetTotalWidth;
			relevantHeight = widgetTotalHeight;
			break;
		default:
//			System.out.println("returning; it's not good...currentLayer is: " + currentLayer);
			return;
		}
		
//		System.out.println("just after the switch-block...");
		
		int newWidth = 500;
		int newHeight = 100;
		
		
		newWidth = Math.max(newWidth, relevantWidth);
		newHeight = Math.max(newHeight, relevantHeight);
		
//		System.out.println("newWidth is now going to be: " + newWidth + "; newHeight: " + newHeight + ", relevantWidth was: " + relevantWidth + ", relevantHeight: " + relevantHeight);
		
		this.setPreferredSize(new Dimension(newWidth, newHeight));
		this.setMinimumSize(new Dimension(newWidth, newHeight));
		this.setMaximumSize(new Dimension(newWidth, newHeight));
		this.setSize(new Dimension(newWidth, newHeight));
		
		if(scrollPane != null) {
//			System.out.println("now going to revalidate/repaint the scroll pane...");
			scrollPane.revalidate();
			scrollPane.repaint();
		} else {
//			System.out.println("decided not to revalidate/repaint the scroll pane...");
		}
				
		
	}
	
	public void paintComponent(Graphics g) {
		super.paintComponents(g);
		
		Color origCol = g.getColor();
		
		g.setColor(Color.white);
		g.fillRect(0, 0, Math.max(this.getPreferredSize().width, parent.getSize().width), Math.max(this.getPreferredSize().height, parent.getSize().width));
		g.setColor(origCol);
		
		int currentLayer;
		
		if(parent == null || parent.getLayerControlPanel() == null) {
			currentLayer = LayerControlPanel.BLOCK_LAYER;
		} else {
			currentLayer = parent.getLayerControlPanel().getCurrentLayer();
		}
		
		switch(currentLayer) {
		case LayerControlPanel.BLOCK_LAYER:
			if(staticBlockPaletteObjects != null) {
				for(StaticBlockPaletteObject p : staticBlockPaletteObjects) {
					p.draw(g);
				}
			}
			break;
		case LayerControlPanel.DOOR_LAYER:
			if(doorPaletteObjects != null) {
				for(PaletteObject p : doorPaletteObjects) {
					p.draw(g);
				}
			}
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
			if(commentaryPaletteObjects != null) {
				for(PaletteObject p : commentaryPaletteObjects) {
					p.draw(g);
				}
			}
			break;
		case LayerControlPanel.ENEMY_LAYER:
			if(enemyPaletteObjects != null) {
				for(PaletteObject p : enemyPaletteObjects){
					p.draw(g);
				}
			}
			break;
		case LayerControlPanel.WIDGET_LAYER:
			if(widgetPaletteObjects != null) {
				for(PaletteObject p : widgetPaletteObjects) {
					p.draw(g);
				}
			}
		}
		
		
	}
	
	
	public void onClick(MouseEvent e) {
		
//		parent.unselectEverything();
		
		switch(parent.getLayerControlPanel().getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			parent.unselectEverything();
			onClickBlock(e);
			break;
		case LayerControlPanel.DOOR_LAYER:
			//parent.unselectEverything();
			onClickDoor(e);
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
//			parent.unselectEverything();
			onClickCommentary(e);
			break;
		case LayerControlPanel.ENEMY_LAYER:
//			parent.unselectEverything();
			onClickEnemy(e);
			break;
		case LayerControlPanel.WIDGET_LAYER:
//			parent.unselectEverything();
			onClickWidget(e);
			break;
		}
		
	}
	
	
	public void onClickWidget(MouseEvent e) {
		
		ArrayList<PaletteObject> toBeDeselected = new ArrayList<PaletteObject>();
		boolean shouldDeselectAll = true;
		
		Point point = new Point(e.getX(), e.getY());
		PaletteObject p = null;
		for(int i = 0; i < widgetPaletteObjects.size(); i++) {
			p = widgetPaletteObjects.get(i);
			if(p.getClickRect().contains(point)) {
				if(p instanceof ObjectSelectPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the widget SELECT cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useUmbrellaArrowCursor();
				} else if(p instanceof WidgetScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useUmbrellaBrushCursor();
				} else if(p instanceof GoalScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useUmbrellaBrushCursor();
					goalPaletteWasClicked(false);
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isCloneButton()) {
//					System.out.println("clone was clicked!");
					parent.cloneCurrentSelection();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).getBlockChar() == ' ') {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useUmbrellaEraserCursor();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isNewButton()) {
					parent.unselectEverything();
//					System.out.println("NEW!");
					newFgWidgetWasClicked();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isEditButton()) {
					parent.unselectEverything();
//					System.out.println("EDIT!");
					shouldDeselectAll = false;
					editFgWidgetWasClicked();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isNewHurtzoneButton()) {
					parent.unselectEverything();
//					System.out.println("EDIT!");
					shouldDeselectAll = false;
					newHurtzoneWasClicked();
				} else if(p instanceof LevelStartPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useCrossHeirsBrushCursor();
				} else if(p instanceof HurtzonePaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useHurtzoneBrushCursor();
				} else if(p instanceof ForwardBackwardPaletteObject) {
					
//					System.out.println("<><>DELME about to move either forward or backward...");
					((ForwardBackwardPaletteObject)p).onClick(e, point, parent.getWidgetLayerScreenObjects());
					parent.repaint();
					
				}
			} else {
				//p.setSelected(false);
				toBeDeselected.add(p);
			}
		}
		
		if(shouldDeselectAll)
			deselectItems(toBeDeselected);
		
		this.repaint();
		
	}
	
	
	public void onClickEnemy(MouseEvent e) {

		ArrayList<PaletteObject> toBeDeselected = new ArrayList<PaletteObject>();
		boolean shouldDeselectAll = true;
		
		Point point = new Point(e.getX(), e.getY());
		PaletteObject p = null;
		for(int i = 0; i < enemyPaletteObjects.size(); i++) {
			p = enemyPaletteObjects.get(i);
			if(p.getClickRect().contains(point)) {
				if(p instanceof ObjectSelectPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the enemy SELECT cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useEnemyArrowCursor();
				} else if(p instanceof RedEnemyScreenPaletteObject 
						|| p instanceof BlueEnemyScreenPaletteObject 
						|| p instanceof GreenEnemyScreenPaletteObject 
						|| p instanceof GrayEnemyScreenPaletteObject
						|| p instanceof YellowEnemyScreenPaletteObject
						|| p instanceof VioletEnemyScreenPaletteObject
						|| p instanceof RainbowBossScreenPaletteObject
						|| p instanceof RogueBlockScreenPaletteObject
						|| p instanceof VerticalBlockScreenPaletteObject
						|| p instanceof HorizontalBlockScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useEnemyBrushCursor();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isCloneButton()) {
//					System.out.println("clone was clicked!");
					parent.cloneCurrentSelection();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).getBlockChar() == ' ') {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useEnemyEraserCursor();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isNewButton()) {
					parent.unselectEverything();
					if(((StaticBlockPaletteObject)p).isEditButton()) {
						newConveyorWasClicked();
					} else {
						newRogueBlockWasClicked();
					}
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isEditButton()) {
					parent.unselectEverything();
					shouldDeselectAll = false;
					editRogueBlockWasClicked();
				} else if(p instanceof ConveyorPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useEnemyBrushCursor();
				} else if(p instanceof ForwardBackwardPaletteObject) {
					
//					System.out.println("<><>DELME about to move either forward or backward...");
					((ForwardBackwardPaletteObject)p).onClick(e, point, parent.getEnemyLayerScreenObjects());
					parent.repaint();
					
				}
			} else {
				//p.setSelected(false);
				toBeDeselected.add(p);
			}
		}
		
		if(shouldDeselectAll)
			deselectItems(toBeDeselected);
		
		this.repaint();
		
		
	}
	
	public void onClickCommentary(MouseEvent e) {
		
		ArrayList<PaletteObject> toBeDeselected = new ArrayList<PaletteObject>();
		boolean shouldDeselectAll = true;
		
		Point point = new Point(e.getX(), e.getY());
		PaletteObject p = null;
		
		for(int i = 0; i < commentaryPaletteObjects.size(); i++) {
			p = commentaryPaletteObjects.get(i);
			if(p.getClickRect() != null && p.getClickRect().contains(point)) {
				
				
//				System.out.println("p istanceof: " + p.getClass().getCanonicalName());
				if(p instanceof StaticBlockPaletteObject) {
					StaticBlockPaletteObject s = (StaticBlockPaletteObject) p;
//					System.out.println("p is StaticBlockPaletteObject; char: " + s.getBlockChar() + ", edit: " + s.isEditButton() + ", new: " + s.isNewButton());
				}
				
				
				if(p instanceof ObjectSelectPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the comment SELECT cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useRadioArrowCursor();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isCloneButton()) {
//					System.out.println("clone was clicked!");
					parent.cloneCurrentSelection();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isNewButton()) {
					parent.unselectEverything();
					if(((StaticBlockPaletteObject)p).getBlockChar() == 's') {
//						System.out.println("placeholder for create new sign");
						newCommentWidgetWasClicked();
					} else if(((StaticBlockPaletteObject)p).getBlockChar() == 'r') {
//						System.out.println("placeholder for create new radio");
						newCommentRadioWasClicked();
					} else if(((StaticBlockPaletteObject)p).getBlockChar() == 'd') {
						newCommentDoorWasClicked();
					}
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isEditButton()) {
					parent.unselectEverything();
//					System.out.println("placeholder for edit");
					
					editCommentLayerWasClicked();
					
					
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).getBlockChar() == ' ') {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useRadioEraserCursor();
				} else if(p instanceof WidgetScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useRadioBrushCursor();
				} else if(p instanceof RadioScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useRadioBrushCursor();
				} else if(p instanceof DoorSourcePaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useDoorBrushCursor();
				} else if(p instanceof DoorDestinationPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useCrossHeirsBrushCursor();
				} else if(p instanceof ForwardBackwardPaletteObject) {
					
//					System.out.println("<><>DELME about to move either forward or backward...");
					((ForwardBackwardPaletteObject)p).onClick(e, point, parent.getCommentaryLayerScreenObjects());
					parent.repaint();
					
				}
				
			} else {
				//p.setSelected(false);
				toBeDeselected.add(p);
			}
		}
		
		
		if(shouldDeselectAll) {
			deselectItems(toBeDeselected);
		}

		this.repaint();
		
	}
	
	public void onClickDoor(MouseEvent e) {
		
		ArrayList<PaletteObject> toBeDeselected = new ArrayList<PaletteObject>();
		boolean shouldDeselectAll = true;
		
		Point point = new Point(e.getX(), e.getY());
		PaletteObject p = null;
		for(int i = 0; i < doorPaletteObjects.size(); i++) {
			p = doorPaletteObjects.get(i);
			if(p.getClickRect() != null && p.getClickRect().contains(point)) {
				if(p instanceof ObjectSelectPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the widget SELECT cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useDoorArrowCursor();
				} else if(p instanceof HeartScreenPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the hearty widget brush cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useWidgetBrushCursor();
				} else if(p instanceof FlagScreenPaletteObject) {
					parent.unselectEverything();
//					System.out.println("about to use the flaggy widget brush cursor...");
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useWidgetBrushCursor();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isCloneButton()) {
//					System.out.println("clone was clicked!");
					parent.cloneCurrentSelection();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isNewButton()) {
					parent.unselectEverything();
//					System.out.println("new widget was clicked!");
					if(((StaticBlockPaletteObject)p).isEditButton()) {
						newDoorWasClicked();
					} else {
						newBgWidgetWasClicked();
					}
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).isEditButton()) {
					parent.unselectEverything();
					shouldDeselectAll = false;
					editBgWidgetWasClicked();
				} else if(p instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)p).getBlockChar() == ' ') {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useDoorEraserCursor();
				} else if(p instanceof WidgetScreenPaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useWidgetBrushCursor();
				} else if(p instanceof DoorSourcePaletteObject) {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useDoorBrushCursor();
				} else if(p instanceof DoorDestinationPaletteObject) {
					p.setSelected(true);
					parent.unselectEverything();
					setSelectedObject(p);
					parent.getEditorCanvas().useCrossHeirsBrushCursor();
				} else if(p instanceof ForwardBackwardPaletteObject) {
					
//					System.out.println("<><>DELME about to move either forward or backward...");
					((ForwardBackwardPaletteObject)p).onClick(e, point, parent.getDoorLayerScreenObjects());
					parent.repaint();
					
				} else {
					parent.unselectEverything();
					p.setSelected(true);
					setSelectedObject(p);
					parent.getEditorCanvas().useDefaultCursor();
				}
				
			} else {
				//p.setSelected(false);
				toBeDeselected.add(p);
			}
		}
		
		if(shouldDeselectAll) {
			deselectItems(toBeDeselected);
		}
		
		this.repaint();
		
	}
	
	public void onClickBlock(MouseEvent e) {

		ArrayList<PaletteObject> toBeDeselected = new ArrayList<PaletteObject>();
		boolean shouldDeselectAll = true;
		
		Point point = new Point(e.getX(), e.getY());
		
		boolean clickedWasNewOrEdit = false;
		
		ArrayList<StaticBlockPaletteObject> paletteObjectsToSetToUnselected = new ArrayList<StaticBlockPaletteObject>();
		
		StaticBlockPaletteObject p;
		
		for(int i = 0; i < staticBlockPaletteObjects.size(); i++) {
			
			p = staticBlockPaletteObjects.get(i);
			
			if(p.getClickRect().containsIncludeBorder(point)) {
				
				if(p.isNewButton()) {
					//new button functionality here
					newStaticBlockPaletteObjectWasClicked();
					clickedWasNewOrEdit = true;
				} else if(p.isEditButton()) {
					//edit button functionality here
					editStaticBlockPaletteObjectWasClicked();
					clickedWasNewOrEdit = true;
				} else {
					p.setSelected(true);
					this.setSelectedObject(p);
					if(p.getBlockChar() == ' ') {
						parent.getEditorCanvas().useBlockEraserCursor();
					} else {
						parent.getEditorCanvas().useBlockBrushCursor();
					}
				}
			} else {
				paletteObjectsToSetToUnselected.add(p);
			}
		}
		
		
		if(!clickedWasNewOrEdit) {
			for(int i = 0; i < paletteObjectsToSetToUnselected.size(); i++) {
				p = paletteObjectsToSetToUnselected.get(i);
				p.setSelected(false);
			}
		}
		
		
		this.repaint();
		
	}
	
	
	
	
	public void deselectItems(ArrayList<PaletteObject> toBeDeselected) {
		
		for(int i = 0; i < toBeDeselected.size(); i++) {
			toBeDeselected.get(i).setSelected(false);
		}
		
	}
	
	
	
	public void addNewToBlockPalette() {
		
		
		int newbieClickRectMinX = staticBlockTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_static_block.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;//parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = 50;//parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		staticBlockPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		staticBlockTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(staticBlockTotalWidth > this.getPreferredSize().width || staticBlockTotalHeight < maxHeight) {
			
			staticBlockTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addEditToBlockPalette() {
		
		
		int newbieClickRectMinX = staticBlockTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/edit_static_block.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;//parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = 50;//parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		
		
		staticBlockPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		staticBlockTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(staticBlockTotalWidth > this.getPreferredSize().width || staticBlockTotalHeight < maxHeight) {
			
			staticBlockTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addEraserToBlockPalette() {
		
		
		int newbieClickRectMinX = staticBlockTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/eraser.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, ' ', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		
		
		staticBlockPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		staticBlockTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(staticBlockTotalWidth > this.getPreferredSize().width || staticBlockTotalHeight < maxHeight) {
			
			staticBlockTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	
	public void addMoveToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/select_widget.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		ObjectSelectPaletteObject newbie = new ObjectSelectPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent, newImage);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addNewWidgetToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_widget.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addNewDoorToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_door.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, true);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addEditToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/edit_widget.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addEraserToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/eraser.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, ' ', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	
	public void addForwardBackwardToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, 123, 84);
		
		ForwardBackwardPaletteObject newbie = new ForwardBackwardPaletteObject(this.parent, clickRect, this.paddingFromObjectToBorder, this.borderThickness);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addCloneToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/duplicate_selection.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		newbie.setCloneButton(true);
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	
	
	
	public void addHeartToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = HeartScreenObject.HEART_WIDTH_AND_HEIGHT;
		int clickRectDesiredHeight = HeartScreenObject.HEART_WIDTH_AND_HEIGHT;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		
		
		HeartScreenPaletteObject newbie = new HeartScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addFlagToDoorPalette() {
		
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = FlagScreenObject.FLAG_WIDTH_AND_HEIGHT;
		int clickRectDesiredHeight = FlagScreenObject.FLAG_WIDTH_AND_HEIGHT;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		
		
		FlagScreenPaletteObject newbie = new FlagScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addMoveToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/select_mob_block.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		ObjectSelectPaletteObject newbie = new ObjectSelectPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent, newImage);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addNewToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_mob_block.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	

	public void addNewConveyorToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_conveyor.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, true);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addEditToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/edit_enemy_layer.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addCloneToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/duplicate_selection.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		newbie.setCloneButton(true);
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addEraserToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/eraser.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, ' ', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	

	public void addForwardBackwardToEnemyPalette() {
		
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, 123, 84);
		
		ForwardBackwardPaletteObject newbie = new ForwardBackwardPaletteObject(this.parent, clickRect, this.paddingFromObjectToBorder, this.borderThickness);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
//			System.out.println("[][][][]  readjusted!");
			
		}
		
		
		
	}
	
	
	
	
	public void addRedEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		RedEnemyScreenPaletteObject newbie = new RedEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
	}
	
	public void addBlueEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		BlueEnemyScreenPaletteObject newbie = new BlueEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addGreenEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		GreenEnemyScreenPaletteObject newbie = new GreenEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addGrayEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		GrayEnemyScreenPaletteObject newbie = new GrayEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addYellowEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		YellowEnemyScreenPaletteObject newbie = new YellowEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addVioletEnemyToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 48;
		int clickRectDesiredHeight = 48;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		VioletEnemyScreenPaletteObject newbie = new VioletEnemyScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addRainbowBossToEnemyPalette() {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 100;
		int clickRectDesiredHeight = 100;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		RainbowBossScreenPaletteObject newbie = new RainbowBossScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this, parent);
		
		
		enemyPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addMoveToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/select_radio.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		ObjectSelectPaletteObject newbie = new ObjectSelectPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent, newImage);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addNewRadioToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_radio.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, 'r', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addNewSignToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_comment_sign.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, 's', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	public void addNewDoorToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_door_comment.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, 'd', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addEditToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/edit_radio.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;//parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = 50;//parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addCloneToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/duplicate_selection.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		newbie.setCloneButton(true);
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addEraserToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/eraser.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, ' ', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	

	public void addForwardBackwardToCommentPalette() {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, 123, 84);
		
		ForwardBackwardPaletteObject newbie = new ForwardBackwardPaletteObject(this.parent, clickRect, this.paddingFromObjectToBorder, this.borderThickness);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	
	public void addMoveToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/select_umbrella.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		ObjectSelectPaletteObject newbie = new ObjectSelectPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent, newImage);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addNewToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_umbrella.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, true, false);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addNewHurtzoneToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/new_hurtzone.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		newbie.setNewHurtzoneButton(true);
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addEditToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/edit_umbrella.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;//parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = 50;//parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addCloneToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/duplicate_selection.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = 50;
		int clickRectDesiredHeight = 50;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, '\0', paddingFromObjectToBorder, borderThickness, parent, newImage, false, true);
		newbie.setCloneButton(true);
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;

			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	public void addEraserToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/eraser.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = parent.getStaticBlockFactory().getTileWidth();
		int clickRectDesiredHeight = parent.getStaticBlockFactory().getTileHeight();
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		StaticBlockPaletteObject newbie = new StaticBlockPaletteObject(clickRect, ' ', paddingFromObjectToBorder, borderThickness, parent, newImage, false, false);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	

	public void addForwardBackwardToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, 123, 84);
		
		ForwardBackwardPaletteObject newbie = new ForwardBackwardPaletteObject(this.parent, clickRect, this.paddingFromObjectToBorder, this.borderThickness);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	
	
	public void addGoalToWidgetPalette() {
		
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		CustomImageDataII newImage = new CustomImageDataII("/images/goal.GIF", Color.white, parent);
		
		int clickRectDesiredWidth = GoalScreenObject.GOAL_WIDTH;
		int clickRectDesiredHeight = GoalScreenObject.GOAL_HEIGHT;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		goalPalette = new GoalScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, this, this.parent);
		
		
		widgetPaletteObjects.add(goalPalette);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += goalPalette.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
		
	}
	
	
	public void addStartPointToWidgetPalette() {
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = LevelStartPaletteObject.getImageWidth(this);
		int clickRectDesiredHeight = LevelStartPaletteObject.getImageHeight(this);
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		
		levelStartPalette = new LevelStartPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, parent);
		
		
		
		widgetPaletteObjects.add(levelStartPalette);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += levelStartPalette.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
			readjustWidthAndHeight();
			
		}
		
	}
	
	
	
	
	public PaletteObject getCurrentSelection() {
		return selectedObject;
	}
	
	
	
	private void newStaticBlockPaletteObjectWasClicked() {
		
		JDialog frame = new JDialog();
		NewStaticBlockPaletteObjectWizard wizard = new NewStaticBlockPaletteObjectWizard(frame);
		frame.setContentPane(wizard);
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setModal(true);
		
		frame.setVisible(true);
		
		
		if(wizard.wasCancelled())
			return;
		
		char newChar = parent.getNextChar();
		
		if(newChar == '\0') {
			JOptionPane.showMessageDialog(this, "Unable to hold more than 92 static block types.","Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		
		CustomImageDataII newImage = new CustomImageDataII(new File(wizard.getImageFileName()), wizard.getTransparentColor(), parent, parent.getStaticBlockFactory().getTileWidth(), parent.getStaticBlockFactory().getTileHeight());
		
		
		StaticBlockCanvasObject newPaletteItem = new StaticBlockCanvasObject(newImage, wizard.shouldBePassThrough());
		
		parent.getCharactersToBlocks().put(newChar, newPaletteItem);
		
		this.addStaticBlockPaletteItem(newChar);
		
		
	}
	
	
	private void editStaticBlockPaletteObjectWasClicked() {
		
		if(selectedObject == null || !(selectedObject instanceof StaticBlockPaletteObject) || ((StaticBlockPaletteObject) selectedObject).getBlockChar() == ' ')
			return;
		
		char charToBeEdited = ((StaticBlockPaletteObject) this.selectedObject).getBlockChar();
		StaticBlockCanvasObject editablePaletteItem = parent.getCharactersToBlocks().get(charToBeEdited);
		
		JDialog frame = new JDialog();
		NewStaticBlockPaletteObjectWizard wizard 
			= new NewStaticBlockPaletteObjectWizard(frame, 
													editablePaletteItem.getImage().getFileName(), 
													editablePaletteItem.getImage().getTransparentColor(), 
													editablePaletteItem.isPassThrough());
		frame.setContentPane(wizard);
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setModal(true);
		
		frame.setVisible(true);
		
		
		if(wizard.wasCancelled())
			return;
		
		
		
		
		CustomImageDataII newImage = new CustomImageDataII(new File(wizard.getImageFileName()), wizard.getTransparentColor(), parent, parent.getStaticBlockFactory().getTileWidth(), parent.getStaticBlockFactory().getTileHeight());
		
		
		
		
		editablePaletteItem.setImage(newImage);
		editablePaletteItem.setPassThrough(wizard.shouldBePassThrough());
		
		parent.repaint();
		
	}
	
	public void unselectEverything() {
		
		checkToSeeIfCurrentSelectionNeedsAdjustment(null);
		
		for(PaletteObject p : this.doorPaletteObjects) {
			p.setSelected(false);
		}
		
		for(StaticBlockPaletteObject p : this.staticBlockPaletteObjects) {
			p.setSelected(false);
		}
		
		for(PaletteObject p : this.doorPaletteObjects) {
			p.setSelected(false);
		}
		
		boolean foundArrow = false;
		
		for(PaletteObject p : this.enemyPaletteObjects) {
			p.setSelected(false);
			if(p instanceof ObjectSelectPaletteObject)
				foundArrow = true;
		}
		
//		System.out.println("foundArrow: " + foundArrow);
		
		
		for(PaletteObject p : this.widgetPaletteObjects) {
//			if(p == null)
//				System.out.println("WHAT the.../?!");
			p.setSelected(false);
		}
		
		setSelectedObject(null);
		
		this.repaint();
	}
	
	
	private void newBgWidgetWasClicked() {
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Background Widget", null);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
		addBgWidget(images);
		
//		if(images != null && images.length > 0) {
//			
//			int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
//			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//			
//			int clickRectDesiredWidth = images[0].getDesiredWidth();
//			int clickRectDesiredHeight = images[0].getDesiredHeight();
//			
//			
//			
//			
//			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//			
//			
//			
//			WidgetScreenPaletteObject newbie = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
//			
//			doorPaletteObjects.add(newbie);
//			
//			int maxHeight = this.getHeightOfLargestItem();
//			
//			
//			doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//			if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
//				
//				doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//				
//				System.out.println("about to readjust width and height...");
//				readjustWidthAndHeight();
//				
//			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
//			}
//			
//		}
		
		
	}
	
	

	public WidgetScreenPaletteObject addBgWidget(CustomImageDataII [] images) {
		
		
		
		
		if(images != null && images.length > 0) {
			
			int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject newbie = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
			
			doorPaletteObjects.add(newbie);
			
			int maxHeight = this.getHeightOfLargestItem();
			
			
			doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
			if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
				
				doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
				
//				System.out.println("about to readjust width and height...");
				readjustWidthAndHeight();
				
			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
			}
			
			return newbie;
			
		}
		
		return null;
	}
	
	
	

	private void newDoorWasClicked() {
		
		JDialog frame = new JDialog();
		
		DoorDestinationSelectionWizard cap = new DoorDestinationSelectionWizard(this.parent.getMainEditorPanel().getListOfRoomNames(), frame);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 250));
		frame.setMinimumSize(new Dimension(500, 250));
		frame.setPreferredSize(new Dimension(500, 250));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		frame.dispose();
		
		if(cap.wasCancelled())
			return;
		
		CustomImageDataII image = new CustomImageDataII(new File(cap.getDoorImage()), cap.getTransparentColor(), this);
		
		String destinationRoomName = cap.getSelectedRoom();
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		RoomEditorPanel theDestinationRoom = parent.getMainEditorPanel().getRoomByName(destinationRoomName);
		
		DoorSourcePaletteObject newbie = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		
		
		DoorDestinationPaletteObject destPalObj = theDestinationRoom.addDoorDestinationPointPaletteObject(parent, newbie);
		newbie.setDestination(destPalObj);
		
		
	}
	
	
	
	

	public DoorSourcePaletteObject addDoorReturnSourcePaletteObject(DoorLoadData doorLoadData, RoomEditorPanel theDestinationRoom) {
		
		
		
		CustomImageDataII image = doorLoadData.getDoorImage();
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		DoorSourcePaletteObject returnValue = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		
		
		
		doorPaletteObjects.add(returnValue);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += returnValue.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		
		
		DoorDestinationPaletteObject destPalObj = theDestinationRoom.addDoorDestinationPointPaletteObject(parent, returnValue);
		returnValue.setDestination(destPalObj);
		
		if(doorLoadData.getDestination() != null)
			theDestinationRoom.setDestinationDoorSpawnPoint(destPalObj, doorLoadData.getDestination());
		
		return returnValue;
	}
	
	

	public DoorDestinationPaletteObject addDoorDestinationPointPaletteObject(RoomEditorPanel theSourceRoom, DoorSourcePaletteObject doorSourcePaletteObject) {
		
		
		CustomImageDataII image = DoorDestinationPaletteObject.getDoorDestImage(this);
		
		int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
//		DoorSourcePaletteObject newbie = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		DoorDestinationPaletteObject newbie = new DoorDestinationPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, theSourceRoom, parent, doorSourcePaletteObject);
		
		
		doorPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		doorTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(doorTotalWidth > this.getPreferredSize().width || doorTotalHeight < maxHeight) {
			
			doorTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		parent.repaint();
		
		return newbie;
		
	}
	
	
	

	public DoorDestinationPaletteObject addCommentaryDoorDestinationPointPaletteObject(RoomEditorPanel theSourceRoom, DoorSourcePaletteObject doorSourcePaletteObject) {
		
		
		CustomImageDataII image = DoorDestinationPaletteObject.getDoorDestImage(this);
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
//		DoorSourcePaletteObject newbie = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		DoorDestinationPaletteObject newbie = new DoorDestinationPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, theSourceRoom, parent, doorSourcePaletteObject);
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		parent.repaint();
		
		return newbie;
		
	}
	
	
	
	private void editBgWidgetWasClicked() {
		
		PaletteObject currentObj = this.selectedObject;
		
		if(currentObj == null) {
			JOptionPane.showMessageDialog(this, "There is no palette object currently selected.","Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		/*if(currentObj instanceof DoorSourcePaletteObject) {

			JDialog frame = new JDialog();
			
			DoorSourcePaletteObject spo = (DoorSourcePaletteObject) currentObj;
			
			
			DoorDestinationSelectionWizard cap = new DoorDestinationSelectionWizard(this.parent.getMainEditorPanel().getListOfRoomNames(), frame, spo.getDestinationRoom().getStaticBlockFactory().getRoomName(), spo.getImage().getFileName(), spo.getImage().getTransparentColor());
			
			frame.setContentPane(cap);
			
			frame.setMaximumSize(new Dimension(500, 250));
			frame.setMinimumSize(new Dimension(500, 250));
			frame.setPreferredSize(new Dimension(500, 250));
			
			frame.setModal(true);
			
			System.out.println("about to call setVisible");
			
			frame.setVisible(true);
			
			
			System.out.println("Aaaand we're done!");
			frame.dispose();
			
			if(cap.wasCancelled())
				return;
			
			
			String newDestName = cap.getSelectedRoom();
			String newImageName = cap.getDoorImage();
			Color newImageTransColor = cap.getTransparentColor();
			
			CustomImageDataII newImage = new CustomImageDataII(new File(newImageName), newImageTransColor, this);
			//will need to remove the old destination palette object and any associated screen objects
			
			
			
		}*/
		
		if(currentObj instanceof DoorDestinationPaletteObject) {
			
			JDialog theFrame = new JDialog();
			
			EditDoorDestinationPaletteObjectWizard wizard = new EditDoorDestinationPaletteObjectWizard(theFrame);
			theFrame.setContentPane(wizard);
			
			theFrame.setSize(new Dimension(550, 150));
			theFrame.setPreferredSize(new Dimension(550, 150));
			theFrame.setMaximumSize(new Dimension(550, 150));
			theFrame.setMinimumSize(new Dimension(550, 150));
			
			theFrame.setModal(true);
			
			theFrame.setVisible(true);
			
			theFrame.dispose();
			
			if(wizard.wasCancelled())
				return;
			
			
			DoorDestinationPaletteObject casted = (DoorDestinationPaletteObject) currentObj;
			casted.setCaption(wizard.getCaption());
			casted.setCaptionColor(wizard.getCaptionColor());
			
			parent.repaint();
			
			return;
		}
		
		if(!(currentObj instanceof WidgetScreenPaletteObject)) {
			JOptionPane.showMessageDialog(this, "The currently selected palette object was not a widget.  <><>DELME type was: " + currentObj.getClass().getCanonicalName(),"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		CustomImageDataII theImageArray[] = ((WidgetScreenPaletteObject) currentObj).getImageArray();
		
//		System.out.println("theImageArray..." + (theImageArray == null ? "was null!" : ("had size: " + theImageArray.length) ));
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Background Widget", null, theImageArray);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
		if(images != null && images.length > 0) {
			
			int newbieClickRectMinX = doorTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject selectedWidget = (WidgetScreenPaletteObject) selectedObject;
			
			selectedWidget.setImages(images);
			
			int maxWidth = 0;
			int maxHeight = 0;
			
			for(int i = 0; i < images.length; i++) {
				if(images[i].getDesiredWidth() > maxWidth)
					maxWidth = images[i].getDesiredWidth();
				if(images[i].getDesiredHeight() > maxHeight)
					maxHeight = images[i].getDesiredHeight();
			}
			
			int newMinX = selectedWidget.getClickRect().getMinX();
			int newMinY = selectedWidget.getClickRect().getMinY();
			
			int origWidth = selectedWidget.getClickRect().width();
			int subsequentWidth = maxWidth;
			
			
			selectedWidget.getClickRect().resetDimensions(newMinX, newMinY, maxWidth, maxHeight);
			
			maxHeight = this.getHeightOfLargestItem();
			
			int widthChange = subsequentWidth - origWidth;
			
			doorTotalWidth += widthChange;
			doorTotalHeight = maxHeight;
			
			
			int selectedIndex = -1;
			
			for(int i = 0; i < doorPaletteObjects.size(); i++) {
				if(doorPaletteObjects.get(i) == selectedObject) {
					selectedIndex = i;
					break;
				}
			}
			
			if(selectedIndex == -1) {
//				System.out.println("the algorithm to get the selected index didn't work.  Sadface.");
			} else {
				for(int i = selectedIndex + 1; i < doorPaletteObjects.size(); i++) {
					doorPaletteObjects.get(i).getClickRect().move(widthChange, 0);
				}
			}
			
			selectedWidget.altered();
			
			readjustWidthAndHeight();
				
			parent.getEditorCanvas().repaint();
			
		}
		
		
	}
	
	
	public void setSelectedObject(PaletteObject newSelection) {
		checkToSeeIfCurrentSelectionNeedsAdjustment(newSelection);
		selectedObject = newSelection;
	}
	
	public void checkToSeeIfCurrentSelectionNeedsAdjustment(PaletteObject newSelection) {
		
		if(newSelection != null && selectedObject == newSelection) {  //pointer comparison should be okay in this case...
			return;
		}
		
		if(selectedObject instanceof MobileScreenPaletteObject) {
			MobileScreenPaletteObject mpo = (MobileScreenPaletteObject) selectedObject;
			if(mpo.getConstructedObject() != null) {
				mpo.setConstructedObject(null);
			}
		}
		
		
	}
	
	
	public void soundOffEnemyLayerPaletteContents() {
		
//		System.out.println("===============================   now in soundOffEnemyLayerPaletteContents!");
		
		if(enemyPaletteObjects == null) {
//			System.out.println("enemyPaletteObjects was null!");
			return;
		} else {
//			System.out.println("size of enemyPaletteObjects: " + enemyPaletteObjects.size());
		}
		PaletteObject po = null;
		for(int i = 0; i < enemyPaletteObjects.size(); i++) {
			po = enemyPaletteObjects.get(i);
//			System.out.println("at index " + i + ", enemyPaletteObjects has class: " + po.getClass().getCanonicalName() + ", is selected? " + po.isSelected());
		}
		
		
	}
	
	public void setSelectionToSelector() {
		
		int currentLayer = parent.getLayerControlPanel().getCurrentLayer();
		
		ArrayList<PaletteObject> poList = null;
		
		switch(currentLayer) {
		case LayerControlPanel.DOOR_LAYER:
			poList = doorPaletteObjects;
			break;
		case LayerControlPanel.ENEMY_LAYER:
			poList = enemyPaletteObjects;
			break;
		case LayerControlPanel.WIDGET_LAYER:
			poList = widgetPaletteObjects;
			break;
		}
		
		if(poList == null)
			return;
		
		PaletteObject po = null;
		for(int i = 0; i < poList.size(); i++) {
			po = poList.get(i);
			if(po == null) {
				continue;
			} else if(po instanceof ObjectSelectPaletteObject) {
				po.setSelected(true);
				setSelectedObject(po);
			} else {
				po.setSelected( false);
			}
		}
		
	}
	
	
	
	public void editRogueBlockWasClicked() {
		
		if(selectedObject == null || !(selectedObject instanceof ScreenPaletteObject) 
				|| (
						!(selectedObject instanceof RogueBlockScreenPaletteObject) 
						&& !(selectedObject instanceof HorizontalBlockScreenPaletteObject) 
						&& !(selectedObject instanceof VerticalBlockScreenPaletteObject)
						&& !(selectedObject instanceof ConveyorPaletteObject))) {
			JOptionPane.showMessageDialog(null, "Please select a conveyor or a stationary, horizontal, or vertical block before clicking the edit icon.","Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		ScreenPaletteObject currentObj = (ScreenPaletteObject) this.selectedObject;
		
		
		int imageWidth = -1;
		int imageHeight = -1;
		
		if(selectedObject instanceof ConveyorPaletteObject) {
			ConveyorPaletteObject cpo = (ConveyorPaletteObject) selectedObject;
			
			JDialog theParent = new JDialog();
			NewConveyorPaletteObjectWizard wizard = new NewConveyorPaletteObjectWizard(theParent, cpo.getAnimation(), cpo.isPassThru(), cpo.isGoingLeft(), cpo.getSpeed());
			theParent.setContentPane(wizard);
			
			theParent.setSize(new Dimension(900,700));
			theParent.setPreferredSize(new Dimension(900,700));
			theParent.setMaximumSize(new Dimension(900,700));
			theParent.setMinimumSize(new Dimension(900,700));
			
			theParent.setModal(true);
			theParent.setVisible(true);
			
			theParent.dispose();
			if(wizard.getImages() == null)
				return;
			
			
			cpo.setImages(wizard.getImages());
			cpo.setSpeed(wizard.getSpeed());
			cpo.setGoingLeft(wizard.isFacingLeft());
			cpo.setPassThru(wizard.isPassThru());
			
			imageWidth = wizard.getImages()[0].getDesiredWidth();
			imageHeight = wizard.getImages()[0].getDesiredHeight();
			
		} else {
			
	
			
			
			
			NewRogueBlockPaletteObjectWizard wizard = NewRogueBlockPaletteObjectWizard.openWizard(currentObj);
			
//			System.out.println("got through that bit...");
			
			if(wizard.wasCancelled())
				return;
			
			
//			System.out.println("Aaaand we're done!");
			
			String fileName = wizard.getImageFileName();
			imageWidth = wizard.getBlockWidth();
			imageHeight = wizard.getBlockHeight();
			Color transColor = wizard.getTransparentColor().getColor();
			int defaultSpeed = wizard.getDefaultSpeed();
			boolean shouldBePassThru = wizard.shouldBePassThrough();
			
			CustomImageDataII newImage = new CustomImageDataII(new File(fileName), transColor, this, imageWidth, imageHeight);
			
			
			if(currentObj instanceof RogueBlockScreenPaletteObject) {
				
				RogueBlockScreenPaletteObject narrowed = (RogueBlockScreenPaletteObject) currentObj;
				
				narrowed.setImage(newImage);
				narrowed.setFileName(fileName);
				narrowed.setShouldBePassThru(shouldBePassThru);
				narrowed.altered();
				
			} else if(currentObj instanceof HorizontalBlockScreenPaletteObject) {
				HorizontalBlockScreenPaletteObject narrowed = (HorizontalBlockScreenPaletteObject) currentObj;
				
				narrowed.setImage(newImage);
				narrowed.setFileName(fileName);
				narrowed.setShouldBePassThru(shouldBePassThru);
				narrowed.setDefaultSpeed(defaultSpeed);
				narrowed.altered();
				
			} else if(currentObj instanceof VerticalBlockScreenPaletteObject) {
				VerticalBlockScreenPaletteObject narrowed = (VerticalBlockScreenPaletteObject) currentObj;
				
				narrowed.setImage(newImage);
				narrowed.setFileName(fileName);
				narrowed.setShouldBePassThru(shouldBePassThru);
				narrowed.setDefaultSpeed(defaultSpeed);
				narrowed.altered();
				
			}
		}
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		
		
		
		
		
		int newMinX = currentObj.getClickRect().getMinX();
		int newMinY = currentObj.getClickRect().getMinY();
		
		int origWidth = currentObj.getClickRect().width();
		
		
		currentObj.getClickRect().resetDimensions(newMinX, newMinY, imageWidth, imageHeight);
		
		
		int widthChange = imageWidth - origWidth;
		
		
		enemyTotalWidth += widthChange;
		enemyTotalHeight = Math.max(enemyTotalHeight, imageHeight);
		
		
		int selectedIndex = -1;
		
		for(int i = 0; i < enemyPaletteObjects.size(); i++) {
			if(enemyPaletteObjects.get(i) == selectedObject) {
				selectedIndex = i;
				break;
			}
		}
		
		if(selectedIndex == -1) {
//			System.out.println("the algorithm to get the selected index didn't work.  Sadface.");
		} else {
			for(int i = selectedIndex + 1; i < enemyPaletteObjects.size(); i++) {
				enemyPaletteObjects.get(i).getClickRect().move(widthChange, 0);
			}
		}
			
		readjustWidthAndHeight();
			
		parent.getEditorCanvas().repaint();
		
		
		
		
	}
	
	public void newRogueBlockWasClicked() {
		
		NewRogueBlockPaletteObjectWizard wizard = NewRogueBlockPaletteObjectWizard.openWizard();
		
		if(wizard.wasCancelled())
			return;
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = wizard.getBlockWidth();
		int clickRectDesiredHeight = wizard.getBlockHeight();
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		PaletteObject newbie = null;
		
		if(wizard.getKindOfRogueBlock() == NewRogueBlockPaletteObjectWizard.STATIONARY_BLOCK) {
			
			newbie = new RogueBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
					this, wizard.getBlockWidth(), wizard.getBlockHeight(), wizard.getImageFileName(), 
					wizard.getTransparentColor().getColor(), wizard.shouldBePassThrough(), wizard.getImageFileName());
			
		} else if(wizard.getKindOfRogueBlock() == NewRogueBlockPaletteObjectWizard.VERTICAL_BLOCK) {
			
			newbie = new VerticalBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
					wizard.getBlockWidth(), wizard.getBlockHeight(), wizard.getImageFileName(), 
					wizard.getTransparentColor().getColor(), this, wizard.shouldBePassThrough(), wizard.getDefaultSpeed(), wizard.getImageFileName());
			
		} else if(wizard.getKindOfRogueBlock() == NewRogueBlockPaletteObjectWizard.HORIZONTAL_BLOCK) {
			
			newbie = new HorizontalBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
					wizard.getBlockWidth(), wizard.getBlockHeight(), wizard.getImageFileName(), 
					wizard.getTransparentColor().getColor(), this, wizard.shouldBePassThrough(), wizard.getDefaultSpeed(), wizard.getImageFileName());
			
		}
		
		
		
		if(newbie == null)
			return;
		

		enemyPaletteObjects.add(newbie);
		
		
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
	}
	
	public RogueBlockScreenPaletteObject addRogueBlock(int width, int height, String imageFileName, Color transparentColor, boolean passThru) {
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = width;
		int clickRectDesiredHeight = height;
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		RogueBlockScreenPaletteObject newbie = null;
			
		newbie = new RogueBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
				this, width, height, imageFileName, 
				transparentColor, passThru, imageFileName);
			
		
		
		
		
		
		
		

		enemyPaletteObjects.add(newbie);
		
		
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
		
	}
	
	
	
	public VerticalBlockScreenPaletteObject addVerticalMovingBlock(int width, int height, String imageFileName, Color transparentColor, boolean passThru, int defaultSpeed) {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = width;
		int clickRectDesiredHeight = height;
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		VerticalBlockScreenPaletteObject newbie = null;
		
		
		newbie = new VerticalBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
				width, height, imageFileName, 
				transparentColor, this, passThru, defaultSpeed, imageFileName);
			
		
		
		
		
		enemyPaletteObjects.add(newbie);
		
		
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
		
	}
	
	
	public HorizontalBlockScreenPaletteObject addHorizontalMovingBlock(int width, int height, String imageFileName, Color transparentColor, boolean passThru, int defaultSpeed) {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = width;
		int clickRectDesiredHeight = height;
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		HorizontalBlockScreenPaletteObject newbie = null;
		
		
		newbie = new HorizontalBlockScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, 
				width, height, imageFileName, 
				transparentColor, this, passThru, defaultSpeed, imageFileName);
			
		
		
		
		
		enemyPaletteObjects.add(newbie);
		
		
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
		
	}
	
	
	
	public void newConveyorWasClicked() {
		
		JDialog theParent = new JDialog();
		NewConveyorPaletteObjectWizard wizard = new NewConveyorPaletteObjectWizard(theParent);
		theParent.setContentPane(wizard);
		
		theParent.setSize(new Dimension(900,700));
		theParent.setPreferredSize(new Dimension(900,700));
		theParent.setMaximumSize(new Dimension(900,700));
		theParent.setMinimumSize(new Dimension(900,700));
		
		theParent.setModal(true);
		theParent.setVisible(true);
		
		if(wizard.getImages() == null)
			return;
		
//		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
//		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//		
//		CustomImageDataII images[] = wizard.getImages();
//		
//		int clickRectDesiredWidth = images[0].getDesiredWidth();
//		int clickRectDesiredHeight = images[0].getDesiredHeight();
//		
//		
//		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//		
//		int theSpeed = -1;
//		
//		try {
//			theSpeed = wizard.getSpeed();
//		} catch(Exception e) {
//			JOptionPane.showMessageDialog(this, "Unable to create conveyor; given speed was not a number.","Error", JOptionPane.WARNING_MESSAGE);
//			return;
//		}
//		
//		
//		ConveyorPaletteObject newbie = new ConveyorPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images, wizard.isFacingLeft(), theSpeed, wizard.isPassThru());
//		
//		
//		
//		
//		
//		enemyPaletteObjects.add(newbie);
//		
//		
//		
//		int maxHeight = this.getHeightOfLargestItem();
//		
//		
//		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
//			
//			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//			
//			System.out.println("about to readjust width and height...");
//			readjustWidthAndHeight();
//			
//		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
//		}
		
		
		int theSpeed = -1;
		
		try {
			theSpeed = wizard.getSpeed();
		} catch(Exception e) {
			JOptionPane.showMessageDialog(this, "Unable to create conveyor; given speed was not a number.","Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		
		addConveyorPalette(wizard.getImages(), wizard.getImages()[0].getDesiredWidth(), wizard.getImages()[0].getDesiredHeight(), theSpeed, wizard.isFacingLeft() ? 'l' : 'r', wizard.isPassThru());
		
		
	}
	
	
	public ConveyorPaletteObject addConveyorPalette(CustomImageDataII images[], int width, int height, int theSpeed, char dir, boolean isPassThru) {
		
		
		int newbieClickRectMinX = enemyTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
//		CustomImageDataII images[] = wizard.getImages();
		
//		int clickRectDesiredWidth = images[0].getDesiredWidth();
//		int clickRectDesiredHeight = images[0].getDesiredHeight();
		
		int clickRectDesiredWidth = width;
		int clickRectDesiredHeight = height;
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
//		int theSpeed = -1;
		
//		try {
//			theSpeed = wizard.getSpeed();
//		} catch(Exception e) {
//			JOptionPane.showMessageDialog(this, "Unable to create conveyor; given speed was not a number.","Error", JOptionPane.WARNING_MESSAGE);
//			return;
//		}
		
		
		ConveyorPaletteObject newbie = new ConveyorPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images, dir == 'l', theSpeed, isPassThru);
		
		
		
		
		
		enemyPaletteObjects.add(newbie);
		
		
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		enemyTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(enemyTotalWidth > this.getPreferredSize().width || enemyTotalHeight < maxHeight) {
			
			enemyTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
		
	}
	
	
	
	private void goalPaletteWasClicked(boolean rightClicked) {
		
		
		if(goalPalette.getCutscene() == null || rightClicked) {
			
			JDialog frame = new JDialog();
			GoalSetupWizard panel;
			if(goalPalette.getClickRect() == null) {
				panel = new GoalSetupWizard(frame);
			} else {
				panel = new GoalSetupWizard(frame, goalPalette.getCutscene(), goalPalette.isPassThru(), goalPalette.isEnableCommentary());
			}
			frame.setContentPane(panel);
			
			frame.setModal(true);
			
			frame.setSize(new Dimension(900, 700));
			
			frame.setVisible(true);
			
			
			frame.dispose();
			
			
			
			CustomImageDataII cutscene[] = panel.getAnimPanel().getFinalResult();
			
			if(cutscene == null) {
				
				if(goalPalette.getCutscene() == null) {
					
					setSelectedObject(null);
					goalPalette.setSelected(false);
					
					JOptionPane.showMessageDialog(this, "Sorry, but without a cutscene, you can't have a goal object.","Problem", JOptionPane.WARNING_MESSAGE);
					
				}
				
				
				return;
			}
				
			
			boolean shouldBePassThru = panel.shouldBePassThru();
			boolean shouldEnableCommentary = panel.shouldEnableCommentary();
			
			goalPalette.setCutscene(cutscene);
			goalPalette.setPassThru(shouldBePassThru);
			goalPalette.setEnableCommentary(shouldEnableCommentary);
			
			
			
		}
		
		
	}
	
	
	

	private void newCommentWidgetWasClicked() {
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Commentary Widget", null);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
		addCommentWidget(images);
		
//		if(images != null && images.length > 0) {
//			
//			int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
//			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//			
//			int clickRectDesiredWidth = images[0].getDesiredWidth();
//			int clickRectDesiredHeight = images[0].getDesiredHeight();
//			
//			
//			
//			
//			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//			
//			
//			
//			WidgetScreenPaletteObject newbie = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
//			
//			commentaryPaletteObjects.add(newbie);
//			
//			int maxHeight = this.getHeightOfLargestItem();
//			
//			
//			commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//			if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
//				
//				commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//				
//				System.out.println("about to readjust width and height...");
//				readjustWidthAndHeight();
//				
//			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
//			}
//			
//		}
		
		
	}
	
	
	
	

	public WidgetScreenPaletteObject addCommentWidget(CustomImageDataII [] images) {
		
		
		
		
		if(images != null & images.length > 0) {
			
			int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject returnValue = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
			
			commentaryPaletteObjects.add(returnValue);
			
			int maxHeight = this.getHeightOfLargestItem();
			
			
			commentaryTotalWidth += returnValue.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
			if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
				
				commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
				
//				System.out.println("about to readjust width and height...");
				readjustWidthAndHeight();
				
			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
			}
			
			return returnValue;
			
		}
		
		return null;
	}
	
	
	
	

	private void newCommentRadioWasClicked() {
		
		NewRadioPaletteObjectWizard wizard = NewRadioPaletteObjectWizard.openWizard();
		
		if(!wizard.wasCancelled()) {
			
			
			String waveFile = wizard.getWaveFile();
			String caption = wizard.getCaption();
			Color captionColor = wizard.getCaptionColor();
			Clip soundClip = wizard.getClip();
			
			addRadio(waveFile, caption, captionColor, soundClip);
			
//			int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
//			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//			
//			int clickRectDesiredWidth = RadioScreenObject.getRadioImage(this).getDesiredWidth();
//			int clickRectDesiredHeight = RadioScreenObject.getRadioImage(this).getDesiredHeight();
//			
//			
//			
//			
//			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//			
//			
//			
//			RadioScreenPaletteObject newbie = new RadioScreenPaletteObject(waveFile, caption, captionColor, paddingFromObjectToBorder, borderThickness, clickRect, soundClip, this);
//			
//			commentaryPaletteObjects.add(newbie);
//			
//			int maxHeight = this.getHeightOfLargestItem();
//			
//			if(newbie == null) {
//				System.out.println("how'd newbie get null?");
//			} else if(newbie.getClickRect() == null) {
//				System.out.println("how'd the clickRect get null?");
//			}
//			
//			commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//			if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
//				
//				commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//				
//				System.out.println("about to readjust width and height...");
//				readjustWidthAndHeight();
//				
//			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
//			}
//			
		}
		
		parent.repaint();
		
	}
	
	public RadioScreenPaletteObject addRadio(String waveFile, String caption, Color captionColor, Clip soundClip) {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = RadioScreenObject.getRadioImage(this).getDesiredWidth();
		int clickRectDesiredHeight = RadioScreenObject.getRadioImage(this).getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		
		
		RadioScreenPaletteObject newbie = new RadioScreenPaletteObject(waveFile, caption, captionColor, paddingFromObjectToBorder, borderThickness, clickRect, soundClip, this);
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
//		if(newbie == null) {
//			System.out.println("how'd newbie get null?");
//		} else if(newbie.getClickRect() == null) {
//			System.out.println("how'd the clickRect get null?");
//		}
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
	}
	
	
	private void newCommentDoorWasClicked() {
		
		JDialog frame = new JDialog();
		
		DoorDestinationSelectionWizard cap = new DoorDestinationSelectionWizard(this.parent.getMainEditorPanel().getListOfRoomNames(), frame);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 250));
		frame.setMinimumSize(new Dimension(500, 250));
		frame.setPreferredSize(new Dimension(500, 250));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		frame.dispose();
		
		if(cap.wasCancelled())
			return;
		
		CustomImageDataII image = new CustomImageDataII(new File(cap.getDoorImage()), cap.getTransparentColor(), this);
		String destinationRoomName = cap.getSelectedRoom();
		
		addCommentDoor(image, destinationRoomName);
		
		
//		String destinationRoomName = cap.getSelectedRoom();
//		
//		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
//		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//		
//		int clickRectDesiredWidth = image.getDesiredWidth();
//		int clickRectDesiredHeight = image.getDesiredHeight();
//		
//		
//		
//		
//		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//		
//		RoomEditorPanel theDestinationRoom = parent.getMainEditorPanel().getRoomByName(destinationRoomName);
//		
//		DoorSourcePaletteObject newbie = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
//		
//		
//		
//		commentaryPaletteObjects.add(newbie);
//		
//		int maxHeight = this.getHeightOfLargestItem();
//		
//		
//		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
//			
//			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//			
//			System.out.println("about to readjust width and height...");
//			readjustWidthAndHeight();
//			
//		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
//		}
//			
//		
//		
//		DoorDestinationPaletteObject destPalObj = theDestinationRoom.addCommentaryDoorDestinationPointPaletteObject(parent, newbie);
//		newbie.setDestination(destPalObj);
		
		
	}
	
	
	public DoorSourcePaletteObject addCommentDoorReturnSourcePaletteObject(DoorLoadData doorLoadData, RoomEditorPanel theDestinationRoom) {
		
		CustomImageDataII image = doorLoadData.getDoorImage();
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		DoorSourcePaletteObject returnValue = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		
		
		
		commentaryPaletteObjects.add(returnValue);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += returnValue.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		
		
		DoorDestinationPaletteObject destPalObj = theDestinationRoom.addCommentaryDoorDestinationPointPaletteObject(parent, returnValue);
		returnValue.setDestination(destPalObj);
		
		if(doorLoadData.getDestination() != null)
			theDestinationRoom.setDestinationCommentDoorSpawnPoint(destPalObj, doorLoadData.getDestination());
		
		return returnValue;
		
	}
	
	
	
	public DoorSourcePaletteObject addCommentDoor(CustomImageDataII image, String destinationRoomName) {
		
		
		int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = image.getDesiredWidth();
		int clickRectDesiredHeight = image.getDesiredHeight();
		
		
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		RoomEditorPanel theDestinationRoom = parent.getMainEditorPanel().getRoomByName(destinationRoomName);
		
		DoorSourcePaletteObject newbie = new DoorSourcePaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, image, parent, theDestinationRoom);
		
		
		
		commentaryPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		commentaryTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(commentaryTotalWidth > this.getPreferredSize().width || commentaryTotalHeight < maxHeight) {
			
			commentaryTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
			
		
//		if(theDestinationRoom == null) {
//			System.err.println("Error:  theDestinationRoom was null!  destinationRoomName: " + destinationRoomName);
//			
//			Map<Thread, StackTraceElement[]> stackMap =   Thread.getAllStackTraces();
//			
//			Thread currentThread = Thread.currentThread();
//			
//			StackTraceElement steArray[] = stackMap.get(currentThread);
//			
//			
//			for(StackTraceElement ste : steArray) {
//				System.out.println("stack trace:  class " + ste.getClassName() + ", method " + ste.getMethodName() + ", line " + ste.getLineNumber());
//			}
			
//		} else {
//			
//			System.err.println("it's not null, actually.  Weird that it's getting that exception, then...");
//			
//		}
		DoorDestinationPaletteObject destPalObj = 
				theDestinationRoom.addCommentaryDoorDestinationPointPaletteObject(
						parent, 
						newbie);
		newbie.setDestination(destPalObj);
		
		
		return newbie;
	}
	
	
	private void editCommentLayerWasClicked() {
		
		PaletteObject currentObj = this.selectedObject;
		
		if(currentObj == null) {
			JOptionPane.showMessageDialog(this, "There is nothing selected.  Please select either a Radio or a Widget palette item if you want to edit." ,"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		} else if(currentObj instanceof WidgetScreenPaletteObject) {
			editCommentWidgetWasClicked();
		} else if(currentObj instanceof RadioScreenPaletteObject) {
			editCommentRadioWasClicked();
		} else {
			JOptionPane.showMessageDialog(this, "Please select either a Radio or a Widget palette item if you want to edit." ,"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
	}
	
	
	private void editCommentWidgetWasClicked() {
		
		PaletteObject currentObj = this.selectedObject;
		
		if(currentObj == null || !(currentObj instanceof WidgetScreenPaletteObject)) {
			JOptionPane.showMessageDialog(this, "The currently selected palette object was not a widget.  <><>DELME type was: " + currentObj.getClass().getCanonicalName(),"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		CustomImageDataII theImageArray[] = ((WidgetScreenPaletteObject) currentObj).getImageArray();
		
//		System.out.println("theImageArray..." + (theImageArray == null ? "was null!" : ("had size: " + theImageArray.length) ));
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Background Widget", null, theImageArray);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
		if(images != null && images.length > 0) {
			
			int newbieClickRectMinX = commentaryTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject selectedWidget = (WidgetScreenPaletteObject) selectedObject;
			
			selectedWidget.setImages(images);
			
			int maxWidth = 0;
			int maxHeight = 0;
			
			for(int i = 0; i < images.length; i++) {
				if(images[i].getDesiredWidth() > maxWidth)
					maxWidth = images[i].getDesiredWidth();
				if(images[i].getDesiredHeight() > maxHeight)
					maxHeight = images[i].getDesiredHeight();
			}
			
			int newMinX = selectedWidget.getClickRect().getMinX();
			int newMinY = selectedWidget.getClickRect().getMinY();
			
			int origWidth = selectedWidget.getClickRect().width();
			int subsequentWidth = maxWidth;
			
			
			selectedWidget.getClickRect().resetDimensions(newMinX, newMinY, maxWidth, maxHeight);
			
			maxHeight = this.getHeightOfLargestItem();
			
			int widthChange = subsequentWidth - origWidth;
			
			commentaryTotalWidth += widthChange;
			commentaryTotalHeight = maxHeight;
			
			
			int selectedIndex = -1;
			
			for(int i = 0; i < commentaryPaletteObjects.size(); i++) {
				if(commentaryPaletteObjects.get(i) == selectedObject) {
					selectedIndex = i;
					break;
				}
			}
			
			if(selectedIndex == -1) {
//				System.out.println("the algorithm to get the selected index didn't work.  Sadface.");
			} else {
				for(int i = selectedIndex + 1; i < widgetPaletteObjects.size(); i++) {
					commentaryPaletteObjects.get(i).getClickRect().move(widthChange, 0);
				}
			}
			
			selectedWidget.altered();
			
			readjustWidthAndHeight();
				
			parent.getEditorCanvas().repaint();
			
		}
		
		
	}
	
	
	
	
	private void editCommentRadioWasClicked() {
		
		if(selectedObject == null || !(selectedObject instanceof RadioScreenPaletteObject)) {
			JOptionPane.showMessageDialog(this, "The currently selected palette object was not a radio.  <><>DELME type was: " + selectedObject.getClass().getCanonicalName(),"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		RadioScreenPaletteObject theRadio = (RadioScreenPaletteObject) this.selectedObject;
		
		
		NewRadioPaletteObjectWizard wizard = NewRadioPaletteObjectWizard.openWizard(
																			 theRadio.getWaveFile(),
																			 theRadio.getCaption(),
																			 theRadio.getCaptionColor(),
																			 theRadio.getClip());
		
		if(wizard.wasCancelled())
			return;
		
		String fileName = wizard.getWaveFile();
		String caption = wizard.getCaption();
		Color captionColor = wizard.getCaptionColor();
		Clip clip = wizard.getClip();
		
		theRadio.setWaveFile(fileName);
		theRadio.setCaption(caption);
		theRadio.setCaptionColor(captionColor);
		theRadio.setClip(clip);
		
		parent.repaint();
		
	}
	
	
	
	
	
	
	
	private void newFgWidgetWasClicked() {
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Foreground Widget", null);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
//		if(images != null && images.length > 0) {
//			
//			int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
//			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//			
//			int clickRectDesiredWidth = images[0].getDesiredWidth();
//			int clickRectDesiredHeight = images[0].getDesiredHeight();
//			
//			
//			
//			
//			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//			
//			
//			
//			WidgetScreenPaletteObject newbie = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
//			
//			widgetPaletteObjects.add(newbie);
//			
//			int maxHeight = this.getHeightOfLargestItem();
//			
//			
//			widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//			if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
//				
//				widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//				
//				System.out.println("about to readjust width and height...");
//				readjustWidthAndHeight();
//				
//			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
//			}
//			
//		}
		
		addFgWidget(images);
	}
	
	
	
	
	private void newHurtzoneWasClicked() {
		
//		System.out.println("<><>DELME placeholder for new hurtzone method");
		
		JDialog wizardFrame = new JDialog();
		
		NewHurtzoneWizard w = new NewHurtzoneWizard(wizardFrame);
		wizardFrame.setContentPane(w);
		
		wizardFrame.setMinimumSize(new Dimension(500, 400));
		wizardFrame.setMaximumSize(new Dimension(500, 400));
		wizardFrame.setPreferredSize(new Dimension(500, 400));
		
		wizardFrame.setModal(true);
		
		wizardFrame.setVisible(true);
		
//		while(wizardFrame.isVisible()) {
//			Thread.yield();
//		}
		
		wizardFrame.dispose();
		
		if(w.wasCancelled())
			return;
		
		
		addHurtzone(w.isVertical(), w.getDuration(), w.getMinimumTimeBetweenFirings(), w.getFireChanceNumerator(), w.getFireChanceDenominator(), w.getWarmupTime(), w.getDamage(), w.getMinColor(), w.getMaxColor());
		
//		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
//		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
//		
//		int clickRectDesiredWidth = 60;
//		int clickRectDesiredHeight = 60;
//		
//		
//		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
//		
//		HurtzonePaletteObject newbie = new HurtzonePaletteObject(clickRect, w.isVertical(), w.getDuration(), w.getMinimumTimeBetweenFirings(), w.getFireChanceNumerator(), w.getFireChanceDenominator(), w.getWarmupTime(), w.getDamage(), w.getMinColor(), w.getMaxColor(), borderThickness, paddingFromObjectToBorder, this.parent);
//		
//		
//		widgetPaletteObjects.add(newbie);
//		
//		int maxHeight = this.getHeightOfLargestItem();
//		
//		
//		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
//		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
//			
//			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
//			
//			System.out.println("about to readjust width and height...");
//			readjustWidthAndHeight();
//			
//		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
//		}
		
		
		
	}
	
	public HurtzonePaletteObject addHurtzone(boolean isVertical,
											 int duration,
											 int minTimeBetweenFirings,
											 int fireChanceNumerator,
											 int fireChanceDenominator,
											 int warmupTime,
											 int damage,
											 double minColor,
											 double maxColor) {
		
		int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
		int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
		
		int clickRectDesiredWidth = 60;
		int clickRectDesiredHeight = 60;
		
		
		IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
		
		HurtzonePaletteObject newbie = new HurtzonePaletteObject(clickRect, isVertical, duration, minTimeBetweenFirings, fireChanceNumerator, fireChanceDenominator, warmupTime, damage, minColor, maxColor, borderThickness, paddingFromObjectToBorder, this.parent);
		
		
		widgetPaletteObjects.add(newbie);
		
		int maxHeight = this.getHeightOfLargestItem();
		
		
		widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
		if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
			
			widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
			
//			System.out.println("about to readjust width and height...");
			readjustWidthAndHeight();
			
		} else {
//			System.out.println("decided not to adjust the width and height, after all...");
		}
		
		return newbie;
		
	}
	
	
	

	public WidgetScreenPaletteObject addFgWidget(CustomImageDataII [] images) {
		
		
		
		
		if(images != null && images.length > 0) {
			
			int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject newbie = new WidgetScreenPaletteObject(clickRect, paddingFromObjectToBorder, borderThickness, images);
			
			widgetPaletteObjects.add(newbie);
			
			int maxHeight = this.getHeightOfLargestItem();
			
			
			widgetTotalWidth += newbie.getClickRect().width() + borderThickness * 2 + paddingBetweenObjects + paddingFromObjectToBorder * 2;
			if(widgetTotalWidth > this.getPreferredSize().width || widgetTotalHeight < maxHeight) {
				
				widgetTotalHeight = maxHeight + borderThickness * 2 + paddingBetweenObjects * 2 + paddingFromObjectToBorder * 2;
				
//				System.out.println("about to readjust width and height...");
				readjustWidthAndHeight();
				
			} else {
//				System.out.println("decided not to adjust the width and height, after all...");
			}
			
			return newbie;
			
		}
		
		return null;
	}
	
	
	
	private void editHurtzoneWasClicked(HurtzonePaletteObject paletteObjToBeEdited) {
		
//		System.out.println("<><>DELME placeholder for edit hurtzone");
		
		JDialog wizardFrame = new JDialog();
		
		NewHurtzoneWizard w = new NewHurtzoneWizard(wizardFrame,
													paletteObjToBeEdited.getMinimumWaitTime(),
													paletteObjToBeEdited.getDuration(),
													paletteObjToBeEdited.getWarmupTime(),
													paletteObjToBeEdited.getDamage(),
													paletteObjToBeEdited.getFireChanceNumerator(),
													paletteObjToBeEdited.getFireChanceDenominator(),
													paletteObjToBeEdited.getMinColor(),
													paletteObjToBeEdited.getMaxColor(),
													paletteObjToBeEdited.isVertical());
		wizardFrame.setContentPane(w);
		
		wizardFrame.setMinimumSize(new Dimension(500, 400));
		wizardFrame.setMaximumSize(new Dimension(500, 400));
		wizardFrame.setPreferredSize(new Dimension(500, 400));
		
		wizardFrame.setModal(true);
		
		wizardFrame.setVisible(true);
		
//		while(wizardFrame.isVisible()) {
//			Thread.yield();
//		}
		
		wizardFrame.dispose();
		
		if(w.wasCancelled())
			return;
		
		
		paletteObjToBeEdited.setMinimumWaitTime(w.getMinimumTimeBetweenFirings());
		paletteObjToBeEdited.setDuration(w.getDuration());
		paletteObjToBeEdited.setWarmupTime(w.getWarmupTime());
		paletteObjToBeEdited.setDamage(w.getDamage());
		paletteObjToBeEdited.setFireChanceNumerator(w.getFireChanceNumerator());
		paletteObjToBeEdited.setFireChanceDenominator(w.getFireChanceDenominator());
		paletteObjToBeEdited.setMinColor(w.getMinColor());
		paletteObjToBeEdited.setMaxColor(w.getMaxColor());
		
		
	}
	
	
	private void editFgWidgetWasClicked() {
		
		PaletteObject currentObj = this.selectedObject;
		
		if(currentObj == null || !((currentObj instanceof WidgetScreenPaletteObject) 
				|| (currentObj instanceof GoalScreenPaletteObject) 
				|| (currentObj instanceof HurtzonePaletteObject))) {
			JOptionPane.showMessageDialog(this, "The currently selected palette object was not a widget.  <><>DELME is null? " + (currentObj == null ? "yes" : currentObj.getClass().getCanonicalName()),"Unable to Edit", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		
		if(currentObj instanceof GoalScreenPaletteObject) {
			goalPaletteWasClicked(true);
			return;
		}
		
		if(currentObj instanceof HurtzonePaletteObject) {
			editHurtzoneWasClicked((HurtzonePaletteObject) currentObj);
			parent.repaint();
			return;
		}
		
		
		CustomImageDataII theImageArray[] = ((WidgetScreenPaletteObject) currentObj).getImageArray();
		
//		System.out.println("theImageArray..." + (theImageArray == null ? "was null!" : ("had size: " + theImageArray.length) ));
		
		JDialog frame = new JDialog();
		
		CustomAnimationPanel cap = new CustomAnimationPanel(frame, "Background Widget", null, theImageArray);
		
		frame.setContentPane(cap);
		
		frame.setMaximumSize(new Dimension(500, 600));
		frame.setMinimumSize(new Dimension(500, 600));
		frame.setPreferredSize(new Dimension(500, 600));
		
		frame.setModal(true);
		
//		System.out.println("about to call setVisible");
		
		frame.setVisible(true);
		
		
//		System.out.println("Aaaand we're done!");
		
		CustomImageDataII images[] = cap.getFinalResult();
		
		frame.dispose();
		
		
		if(images != null && images.length > 0) {
			
			int newbieClickRectMinX = widgetTotalWidth + borderThickness + paddingFromObjectToBorder;
			int newbieClickRectMinY = borderThickness + paddingFromObjectToBorder + paddingBetweenObjects;
			
			int clickRectDesiredWidth = images[0].getDesiredWidth();
			int clickRectDesiredHeight = images[0].getDesiredHeight();
			
			
			
			
			IntRect clickRect = new IntRect(newbieClickRectMinX, newbieClickRectMinY, clickRectDesiredWidth, clickRectDesiredHeight);
			
			
			
			WidgetScreenPaletteObject selectedWidget = (WidgetScreenPaletteObject) selectedObject;
			
			selectedWidget.setImages(images);
			
			int maxWidth = 0;
			int maxHeight = 0;
			
			for(int i = 0; i < images.length; i++) {
				if(images[i].getDesiredWidth() > maxWidth)
					maxWidth = images[i].getDesiredWidth();
				if(images[i].getDesiredHeight() > maxHeight)
					maxHeight = images[i].getDesiredHeight();
			}
			
			int newMinX = selectedWidget.getClickRect().getMinX();
			int newMinY = selectedWidget.getClickRect().getMinY();
			
			int origWidth = selectedWidget.getClickRect().width();
			int subsequentWidth = maxWidth;
			
			
			selectedWidget.getClickRect().resetDimensions(newMinX, newMinY, maxWidth, maxHeight);
			
			maxHeight = this.getHeightOfLargestItem();
			
			int widthChange = subsequentWidth - origWidth;
			
			widgetTotalWidth += widthChange;
			widgetTotalHeight = maxHeight;
			
			
			int selectedIndex = -1;
			
			for(int i = 0; i < widgetPaletteObjects.size(); i++) {
				if(widgetPaletteObjects.get(i) == selectedObject) {
					selectedIndex = i;
					break;
				}
			}
			
			if(selectedIndex == -1) {
//				System.out.println("the algorithm to get the selected index didn't work.  Sadface.");
			} else {
				for(int i = selectedIndex + 1; i < widgetPaletteObjects.size(); i++) {
					widgetPaletteObjects.get(i).getClickRect().move(widthChange, 0);
				}
			}
			
			selectedWidget.altered();
			
			readjustWidthAndHeight();
				
			parent.getEditorCanvas().repaint();
			
		}
		
		
	}
	
	
	public RainbowBossScreenPaletteObject setSelectedObjectToRainbowElemental() {
		
		if(parent.getLayerControlPanel().getCurrentLayer() != LayerControlPanel.ENEMY_LAYER)
			return null;
		
		RainbowBossScreenPaletteObject returnValue = null;
		
		for(PaletteObject po : enemyPaletteObjects) {
			if(po instanceof RainbowBossScreenPaletteObject) {
				po.setSelected(true);
				this.setSelectedObject(po);
				returnValue = (RainbowBossScreenPaletteObject) po;
			} else {
				po.setSelected(false);
			}
		}
		
		return returnValue;
	}
	
	public RainbowBossScreenPaletteObject getRainbowElementalPaletteObject() {
		
		RainbowBossScreenPaletteObject returnValue = null;
		
		for(PaletteObject po : enemyPaletteObjects) {
			if(po instanceof RainbowBossScreenPaletteObject) {
				returnValue = (RainbowBossScreenPaletteObject) po;
				break;
			}
		}
		
		return returnValue;
	}

	public ArrayList<StaticBlockPaletteObject> getStaticBlockPaletteObjects() {
		return staticBlockPaletteObjects;
	}

	public ArrayList<PaletteObject> getDoorPaletteObjects() {
		return doorPaletteObjects;
	}

	public ArrayList<PaletteObject> getEnemyPaletteObjects() {
		return enemyPaletteObjects;
	}

	public ArrayList<PaletteObject> getWidgetPaletteObjects() {
		return widgetPaletteObjects;
	}

	public ArrayList<PaletteObject> getCommentaryPaletteObjects() {
		return commentaryPaletteObjects;
	}
	
	
	
	
	public GoalScreenPaletteObject getGoalPalette() {
		
		if(goalPalette != null)
			return goalPalette;
		
		for(PaletteObject po : widgetPaletteObjects) {
			if(po instanceof GoalScreenPaletteObject) {
				return (GoalScreenPaletteObject) po;
			}
		}
		
		
		return null;
	}
	
	
	public LevelStartPaletteObject getLevelStartPaletteObject() {
		return levelStartPalette;
	}
	
	
	public void loadPaletteObjects(BufferedReader in) throws Exception {
		
		
		String inputter = null;
		
		int mode = 0;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("blockDef:")) {
				//load up a blockDef
				loadStaticBlock(in);
			} else if(inputter.contains("widget:")) {
				//load up a widget
				loadWidget(in, mode);
			} else if(inputter.contains("comment_layer:")) {
				mode = 1;
			} else if(inputter.contains("widget_layer:")) {
				mode = 2;
			} else if(inputter.contains("block:")) {
				//load up a rogue block
				loadRogueBlock(in);
			} else if(inputter.contains("movingBlock:")) {
				//load up a moving block
				loadMovingBlock(in);
			}
				
			
		}
		
	}
	
	private void loadStaticBlock(BufferedReader in) throws Exception {
		
		String inputter = null;
		String imageFileName = null;
		Color transColor = null;
		boolean passThru = false;
		
		while((inputter = in.readLine()) != null) {
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("graphic:")) {
				imageFileName = inputter.substring(8);
			} else if(inputter.contains("transparent:")) {
				transColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12));
			} else if(inputter.contains("passThru")) {
				passThru = true;
			} else if(inputter.contains("/blockDef")) {
				break;
			}
		}
		
		CustomImageDataII newImage = new CustomImageDataII(new File(imageFileName), transColor, parent, parent.getStaticBlockFactory().getTileWidth(), parent.getStaticBlockFactory().getTileHeight());
		
		
		StaticBlockCanvasObject newPaletteItem = new StaticBlockCanvasObject(newImage, passThru);
		char newChar = parent.getNextChar();
		parent.getCharactersToBlocks().put(newChar, newPaletteItem);
		
		this.addStaticBlockPaletteItem(newChar);
		
	}
	
	
	private void loadWidget(BufferedReader in, int which) throws Exception {
		
		String inputter = null;
		
		String array[] = null;
		
		CustomImageDataII imageArray[] = null;
		int index = 0;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/widget")) {
				break;
			} else if(imageArray != null) {
				array = inputter.split("\\*");
				imageArray[index++] = new CustomImageDataII(new File(array[0]), CustomAnimationPanel.convertStringToColor(array[1]), this);
			} else if(inputter.contains("frameCount:")) {
				imageArray = new CustomImageDataII[Integer.parseInt(inputter.substring(11).trim())];
			}
			
		}
		
		
		switch(which) {
		case 0:
			addBgWidget(imageArray);
			break;
		case 1:
			addCommentWidget(imageArray);
			break;
		case 2:
			addFgWidget(imageArray);
			break;
		}
	}
	
	
	public void loadRogueBlock(BufferedReader in) throws Exception {
		
		
		
		int width = -1;
		int height = -1;
		String fileName = null;
		Color transColor = null;
		boolean isPassThru = false;
		
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/block")) {
				break;
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7).trim());
			} else if(inputter.contains("graphic:")) {
				fileName = inputter.substring(8);
			} else if(inputter.contains("transparent:")) {
				transColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12));
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
			}
			
		}
		
		
		addRogueBlock(width, height, fileName, transColor, isPassThru);
		
		
	}
	
	
	
	public void loadMovingBlock(BufferedReader in) throws Exception {
		
		
		
		int width = -1;
		int height = -1;
		String fileName = null;
		Color transColor = null;
		boolean isPassThru = false;
		boolean isHorizontal = false;
		int defaultSpeed = -1;
		
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/movingBlock")) {
				break;
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7).trim());
			} else if(inputter.contains("graphic:")) {
				fileName = inputter.substring(8);
			} else if(inputter.contains("transparent:")) {
				transColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12));
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
			} else if(inputter.contains("horizontal")) {
				isHorizontal = true;
			} else if(inputter.contains("defaultSpeed:")) {
				defaultSpeed = Integer.parseInt(inputter.substring(13));
			}
			
		}
		
		
		if(isHorizontal) {
			addHorizontalMovingBlock(width, height, fileName, transColor, isPassThru, defaultSpeed);
			
		} else {
			addVerticalMovingBlock(width, height, fileName, transColor, isPassThru, defaultSpeed);
		}
		
		
	}
	
	
	
	public void loadConveyor(BufferedReader in) throws Exception {
		
		
		
		int width = -1;
		int height = -1;
		boolean isPassThru = false;
		int theSpeed = -1;
		boolean isLeft = false;
		
		String tempArray[] = null;
		String fileNames[] = null;
		Color transColors[] = null;
		int index = 0;
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.length() == 0 || inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/block")) {
				break;
			} else if(fileNames != null) {
				tempArray = inputter.split("\\*");
				fileNames[index] = tempArray[0];
				transColors[index++] = CustomAnimationPanel.convertStringToColor(tempArray[1]);
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7).trim());
			} else if(inputter.contains("frameCount:")) {
				fileNames = new String[Integer.parseInt(inputter.substring(11).trim())];
				transColors = new Color[fileNames.length];
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
			} else if(inputter.contains("speed:")) {
				theSpeed = Integer.parseInt(inputter.substring(6));
			} else if(inputter.toLowerCase().contains("dir:l")) {
				isLeft = true;
			}
			
		}
		
		CustomImageDataII images[] = new CustomImageDataII[fileNames.length];
		
		for(int i = 0; i < fileNames.length; i++) {
			images[i] = new CustomImageDataII(new File(fileNames[i]), transColors[i], this);
		}
		
		addConveyorPalette(images, width, height, theSpeed, isLeft ? 'l' : 'r', isPassThru);
		
		
	}
	
}
